package ru.surfstudio.android.core.mvp.binding

/**
 * Интерфейс описывающий сущность, которая умеет подписываться на изменение данных.
 * Реализует концепцию источников данных: "События изменения данных принимают все, кроме эммитящего источника"
 * Это исключает прослушивания источником своих же событий изменения данных и зацикливания.
 */
interface IBindData<T> {

    /**
     * Текущее значение
     */
    val value: T

    /**
     * Подписка на изменеие значения
     * @param source источник получения данных
     */
    fun observe(source: Any, listener: (T) -> Unit)

    /**
     * Подписывает на изменение значения и вызывает подписку для с текущим значением
     */
    fun observeAndApply(source: Any, listener: (T) -> Unit)

    /**
     * Устанавливает значение и оповещает всех подписчиков, кроме указанного источника
     * @param source источник изменения значения
     * @param newValue новое значение переменной
     * @param eagerNotify оповещать подписчиков, даже если значение не изменилось
     */
    fun setValue(source: Any, newValue: T, eagerNotify: Boolean = false)

    /**
     * Отписывает источник от всех событий
     */
    fun unObserveSource(source: Any)
}